package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Suppression d'un objet de donnes applicatives
 *
 */
public class SupprimerObjet{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(SupprimerObjet.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param idObjet Identifiant de l'obket
	 * @param libelle Libell de l'objet
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, long idObjet, String libelle) throws ExceptionTraitement {

		try {
			
			if(librairie != null) {
		
				Resultat resultat = new Resultat("Suppression de l'objet \""+libelle+"\" (C_DestroyObject)");
				
				try {
					
					// Traitement  tester
					librairie.C_DestroyObject(idSession, idObjet);
					
				} catch (PKCS11Exception e) {

					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_SUPPR, "La librairie est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_SUPPR, "Une erreur inattendue est survenue");
			
		}

	}

}
